<?php 
set_time_limit(0);
define("STATUS_NOT_STATED",     "not_started");
define("STATUS_COMPLETED",     "completed");
define("MAIL_SUMMARY_TEMPLATE",     "summary");
define("MAIL_PHISHING_TEMPLATE",     "phishing");
define("MAIL_TEMPLATE",     "normal");
define("MAIL_EMPTY", "empty");

class Processor {
	private $conn = null;

	function __construct() {
		$this->conn = new mysqli(DB_SERVER_NAME, DB_USERNAME, DB_PASSWORD, DB_NAME);
	}

	public function truncateButtonDataForCurrentMonth()
	{
		$num = 0;

		$data = $this->getAllButtonData();

		$now = new DateTime("now");
    	$currentMonth = (int) $now->format('m');

		foreach ($data as $item) {
			$month = (int) date('m', strtotime($item['PROCESSED_AT']));

			if ($month == $currentMonth - 1) {
				// DELETE
				$this->deleteButtonData($item['ID']);
				$num++;
			}
		}

		return $num;
	}

	protected function getAllButtonData()
	{
		$sql = "SELECT id, processed_at FROM button_data";

		$result = $this->conn->query($sql);

		$data = [];

		while ($row = $result->fetch_row()) {
		    $data[] = array(
		    						'ID'				=> $row[0],
									'PROCESSED_AT'		=> $row[1]
		    					);
		}

		return $data;
	}

	protected function deleteButtonData($button_data_id)
	{
		$sql = "DELETE FROM button_data WHERE id=?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param('i', $button_data_id);

		$stmt->execute();
		$stmt->close();
	}

	protected function mail_template($data, $nameOfContact, $templateType) {
		if($templateType == MAIL_SUMMARY_TEMPLATE) {
			$content = file_get_contents(dirname(__FILE__).'/template_mail_summary.html');
		} else if($templateType == MAIL_PHISHING_TEMPLATE) {
			$content = file_get_contents(dirname(__FILE__).'/template_mail_phishing.html');
		}  else if ($templateType == MAIL_EMPTY) {
			$content = file_get_contents(dirname(__FILE__).'/template_mail_empty.html');

			return str_replace("<%Message%>", "$data", $content);
		}
		else {
			$content = file_get_contents(dirname(__FILE__).'/template_mail.html');
			$content = str_replace("<%ReportTable%>",$data['rows'], $content);
			$content = str_replace("<%campaignName%>", $data['campaignName'], $content);
			$content = str_replace("<%campaignStartDate%>", $data['campaignStart'], $content);
			return str_replace("<%NameOfContact%>","$nameOfContact", $content);
		} 

		$content = str_replace("<%ReportTable%>","$data", $content);
		return str_replace("<%NameOfContact%>","$nameOfContact", $content); 
	}

	public function getEmailAndNameOfContact($companyName) {
		switch ($companyName) {
			case 'Recycled Aggregate Materials Company, Inc':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Ernest';
				break;
			case 'Myers, Widders, Gibson Jones & Feingold, LLP':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Myers';
				break;
			case 'Lee & Associates - Oakland':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Wendy';
				break;
			case 'Lee & Associates - Pleasanton':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Megan';
				break;
			case 'Holland Electronics, LLC':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Tammy';
				break;
			case 'Lee & Associates - Riverside':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Irma';
				break;
			case 'Lee & Associates - Pasadena':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Kasey';
				break;
			case 'Lee & Associates - Investment Services Group':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Fahd';
				break;
			case 'Lee & Associates - LA North/Ventura':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Nanette';
				break;	
			case 'Fluid Networks':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Eric';
				break;
			case 'Pharmaceutic Litho & Label Company, Inc.':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Brian';
				break;
			// case 'LTC Properties, Inc.':
			// 	$toEmail = 'nguyenlehuutai@gmail.com';
			// 	$nameOfContact = 'XXXXX';
			// 	break;
			case 'LTC Properties, Inc.':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'LTC Properties';
				break;
			case 'Kern Regional Center':
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Kern Regional Center';
				break;
			default:
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Fahd';
				break;
		}

		return array('toEmail' => $toEmail, 'nameOfContact' => $nameOfContact);
	}

	public function sendMail($subject, $data, $toEmail, $nameOfContact, $templateType) {
		try {
			global $mail;
			$mail->clearAllRecipients(); // clear all
			$mail->setFrom('donotreply@visible-iq.com');

			// Comment this block out to disable sending test emails to real people

			$toEmailList = explode(",",$toEmail);
			
			foreach ($toEmailList as $key => $value) {
				$mail->addAddress($value);
			}
			
			$mail->addCC("fahdsaeed87@gmail.com");
			$mail->addCC("fahdsaeed87@gmail.com");

			// end comment here

			// un comment for test emails
// 			$mail->addAddress("pelumip15@gmail.com");
// 			$mail->addAddress("fahdsaeed87@gmail.com");
			
			$mail->Subject = $subject;
			$mail->isHTML(TRUE);
			$mail->Body = $this->mail_template($data, $nameOfContact, $templateType);

			$mail->send();


		} catch (Exception $e) {
		    echo "$mail->ErrorInfo";
		}
	}

	public function notifyNoDataSaved()
	{
		$now = new DateTime("now");
		$now = $now->sub(new DateInterval('P1D'));

		$subject = "Cyren Data Import " . "(" . $now->format("m/d/Y") . ")";
		$message = "We were unable to locate any data from Cyren for yesterday. Please investigate."; // Email message goes here

		try {
			global $mail;
			$mail->clearAllRecipients();
			$mail->setFrom('donotreply@visible-iq.com');

			// add more emails below
			$mail->addAddress("fahdsaeed87@gmail.com");
			$mail->addAddress("fahdsaeed87@gmail.com");

			$mail->Subject = $subject;
			$mail->isHTML(TRUE);
			$mail->Body = $this->mail_template($message, "", MAIL_EMPTY);

			$mail->send();
		} catch (Exception $e) {
			return return_json(['error' => $mail->ErrorInfo]);
		}
	}

	public function request($url) {
       	$ch = curl_init(API_HOST . $url);

       	$authorization = "Authorization: Bearer " . API_BEARER_TOKEN;
       	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization ));

       	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

       $response = curl_exec($ch);
       curl_close($ch);
       return json_decode($response);
	}

	private function get_campaign_by_campaign_id(string $campaign_id) {
		$sql = "SELECT * FROM campaigns WHERE BINARY campaign_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $campaign_id);
		$stmt->execute();

		$result = $stmt->get_result();
		$campaign = $result->fetch_assoc();

		$stmt->close();

		return $campaign;
	}

	private function update_campaign($campaign_id, $running)
	{
		$sql = "UPDATE campaigns SET running=? WHERE campaign_id=?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("is", $running, $campaign_id);
		$stmt->execute();
		$stmt->close();
	}

	public function send_phishing_mail($subject, $rowData, $toEmail, $toName)
	{
		$this->sendMail($subject, $rowData, $toEmail, $toName, MAIL_PHISHING_TEMPLATE);
	}

	private function insert_campaign($campaign)
	{
		$running = $campaign->running == true ? 1 : 0;

		$sql = "INSERT INTO campaigns (campaign_id, name, type, running) VALUES (?, ?, ?, ?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("sssi", $campaign->id, $campaign->name, $campaign->type, $running);

		$stmt->execute();
		$stmt->close();
	}

	public function insert_event($event, $eventType, $timestamp, $templateName)
	{
		$sql = "INSERT INTO events (campaign_id, learner_id, type_from_api, type, date_it_occured, template_id, template_name) VALUES (?, ?, ?, ?, ?, ?, ?)";
		$stmt = $this->conn->prepare($sql);
		print_r($this->conn->error);
		$stmt->bind_param("sssssss", $event->campaign_id, $event->learner_id, $event->type, $eventType, $timestamp, $event->template_id, $templateName);

		$stmt->execute();
		$stmt->close();
	}

	public function insert_campaigns($campaigns)
	{
		$updated = 0; $inserted = 0;

		foreach ($campaigns as $campaign) {
			$exists = $this->get_campaign_by_campaign_id($campaign->id);

			if (!is_null($exists)) {
				$running = $campaign->running == true ? 1 : 0;
				if ($exists['running'] != $running) {
					// UPDATE THE CAMPAIGN
					$this->update_campaign($campaign->id, $running);
					$updated++;
				}
			} else {
				// INSERT THE CAMPAIGN
				$this->insert_campaign($campaign);
				$inserted++;
			}
		}

		return "Finished... Inserted $inserted campaigns and Updated $updated campaigns. Fetched " . count($campaigns) . " campaigns";
	}

	public function get_events($eventIds) {
		$sql = "SELECT e.campaign_id, l.first_name, l.last_name, e.date_it_occured, e.type, e.id, e.learner_id, e.template_id, e.template_name, c.name as campaign_name FROM events e
				INNER JOIN learners l ON BINARY e.learner_id = BINARY l.learner_id
				INNER JOIN campaigns c ON BINARY e.campaign_id = BINARY c.campaign_id
				WHERE e.id IN ($eventIds) ORDER BY l.last_name";

		$result = $this->conn->query($sql);

		$data = [];

		while ($row = $result->fetch_assoc()) {
			$data[] = $row;
		}

		return $data;
	}

	public function get_timeline_events_by_campaign($campaigns)
	{
		$data = [];

		foreach ($campaigns as $campaign) {
			$sql = "SELECT e.*, l.company, c.name as company_name FROM events e JOIN learners l ON e.learner_id = l.learner_id JOIN companies c ON c.id = l.company WHERE BINARY e.campaign_id = BINARY ?";

			$stmt = $this->conn->prepare($sql);

			$stmt->bind_param('s', $campaign);
			$stmt->execute();

			$result = $stmt->get_result();

			while ( !is_null( $item = $result->fetch_assoc() ) ) {
				$data[] = $item;
			}

			$stmt->close();
		}

		return $data;
	}

	public function get_timeline_events_by_date($from, $to) 	
	{
		$sql = "SELECT e.*, l.company, c.name as company_name FROM events e JOIN learners l ON e.learner_id = l.learner_id JOIN companies c ON c.id = l.company WHERE e.date_it_occured >= ? AND e.date_it_occured < ?";
		$stmt = $this->conn->prepare($sql);

		$stmt->bind_param('ss', $from, $to);
		$stmt->execute();

		$result = $stmt->get_result();

		$data = [];

		while ( !is_null( $item = $result->fetch_assoc() ) ) {
			$data[] = $item;
		}

		$stmt->close();

		return $data;
	}

	public function get_companies()
	{
		$sql = "SELECT * FROM companies";
		$stmt = $this->conn->prepare($sql);
		$stmt->execute();

		$result = $stmt->get_result();

		$data = [];

		while (!is_null( $item = $result->fetch_assoc() )) {
			$data[] = $item;
		}

		$stmt->close();

		return $data;
	}

// <<<<<<< HEAD
// =======
	public function get_previos_months() {
		$currentMonth = date("m");
		if($currentMonth == 1) {
			$data[] = (date("y") - 1) . '12';
		}

		for ($i=1; $i < $currentMonth; $i++) {
 			$data[] = date("y") . ($i < 10 ? '0' . $i : $i);
 		}

 		return $data;
	}

	private function get_company_by_company_name($name)
	{
		$sql = "SELECT * FROM companies WHERE LOWER(name) = LOWER(?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $name);
		$stmt->execute();

		$result = $stmt->get_result();
		$company = $result->fetch_assoc();
		$stmt->close();

		return $company;
	}

	private function insert_company($name)
	{
		$sql = 'INSERT INTO companies (name) VALUES (?)';
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $name);
		$stmt->execute();
		$stmt->close();

		return $this->conn->insert_id;
	}

	private function get_learner_by_email($email)
	{
		$sql = "SELECT learner_id, email FROM learners WHERE LOWER(email) = LOWER(?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $email);
		$stmt->execute();

		$result = $stmt->get_result();
		$learner = $result->fetch_assoc();

		$stmt->close();

		return $learner;
	}

	private function get_learner_by_learner_id($learner_id)
	{
		$sql = "SELECT * FROM learners WHERE BINARY learner_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $learner_id);
		$stmt->execute();

		$result = $stmt->get_result();
		$learner = $result->fetch_assoc();

		$stmt->close();

		return $learner;
	}

	private function insert_learner($learner, $company, $department)
	{
		$sql = "INSERT INTO learners (learner_id, email, first_name, last_name, company, department, modified) VALUES (?, ?, ?, ?, ?, ?, ?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ssssiss", $learner->id, $learner->email, $learner->first_name, $learner->last_name, $company, $department, $learner->modified);
		$stmt->execute();

		$stmt->close();
	}

	public function insert_learners($learners) 	
	{
		$inserted = 0;

		foreach ($learners as $learner) {
			$exists = $this->get_learner_by_learner_id($learner->id);

			if (is_null($exists)) {
				// INSERT THE LEARNER
				$user = $this->request("learners/" . $learner->id);

				$company_id = null;

				if ($user->learner_profile->custom == "") {
					continue;
				}

				$company = $this->get_company_by_company_name($user->learner_profile->custom);

				if (is_null($company)) {
					$company_id = $this->insert_company($user->learner_profile->custom);
				} else {
					$company_id = $company['id'];
				}

				$this->insert_learner($learner, $company_id, $user->learner_profile->department);
				$inserted++;
			}
		}

		return "Finished... Inserted $inserted learners. Fetched " . count($learners) . " learners";
	}

	public function get_learners_from_list($list)
	{
		$inArr = explode(",", $list);

		$clause = implode(',', array_fill(0, count($inArr), '?'));
		$types = str_repeat('s', count($inArr));

		$sql = "SELECT learner_id, first_name, last_name, department FROM learners WHERE BINARY learner_id IN ($clause)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param($types, ...$inArr);
		$stmt->execute();

		$result = $stmt->get_result();

		$data = [];

		while ($row = $result->fetch_assoc()) {
			$data[] = $row;
		}

		$stmt->close();

		return $data;
	}

	public function get_summary_by_learner($learner_id)
	{
		$sql = "SELECT * FROM learner_run_stats_summary WHERE BINARY learner_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $learner_id);
		$stmt->execute();
		$result = $stmt->get_result();

		$data = [];

		while ($row = $result->fetch_assoc()) {
			$data[] = $row;
		}

		$stmt->close();

		return $data;
	}
	
	public function fetch_campaigns_by_type($type)
	{
		$sql = "SELECT * FROM campaigns WHERE type = ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param('s', $type);
		$stmt->execute();
		$result = $stmt->get_result();

		$data = [];

		while ( !is_null($campaign =  $result->fetch_assoc()) ) {
			$data[] = $campaign;
		}

		$stmt->close();

		return $data;
	}

	public function filter_campaign_by_current_month($campaigns)
	{
		$result = [];

		$now = new DateTime("now");
		$now->modify("-10 day");

		$year = $now->format('y');
		$month = $now->format("m");
		$date = "$year$month";

		foreach ($campaigns as $campaign) {
			$split = explode(" ", $campaign['name']);

			if ((isset($split[1]) && !is_null($split[1])) && $split[1] == $date) {
				$result[] = $campaign;
			}
		}

		return $result;
	}

	private function get_run_by_run_id($run_id)
	{
		$sql = "SELECT * FROM campaign_runs WHERE BINARY run_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $run_id);
		$stmt->execute();

		$result = $stmt->get_result();
		$run = $result->fetch_assoc();

		$stmt->close();

		return $run;
	}
	
	private function insert_run($run)
	{
		$sql = "INSERT INTO campaign_runs (run_id, campaign_id, start, end, run_number) VALUES (?, ?, ?, ?, ?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ssssi", $run->id, $run->campaign_id, $run->start, $run->end, $run->run_number);
		$stmt->execute();

		$stmt->close();
	}

	public function insert_campaign_runs($runs)
	{
		$inserted = 0;

		foreach ($runs as $run) {
			$exists = $this->get_run_by_run_id($run->id);

			if (is_null($exists)) {
				// INSERT
				$this->insert_run($run);
				$inserted++;
			}
		}

		return "Finished... Inserted $inserted runs. Fetched " . count($runs) . " runs";
	}

	public function get_campaigns()
	{
		$data = [];
		$sql = "SELECT * FROM campaigns";
		$stmt = $this->conn->prepare($sql);
		$stmt->execute();
		$result = $stmt->get_result();

		while ( !is_null( $campaign = $result->fetch_assoc() ) ) {
			$data[] = $campaign;
		}

		$stmt->close();

		return $data;
	}

	public function filter_campaigns_by_prev_month($campaigns)
	{
		$now = new DateTime('now');
		$now->sub(new DateInterval("P1M"));

		$year = $now->format("y");
		$month = $now->format("m");

		$prev = "$year$month";

		$result = [];

		foreach ($campaigns as $campaign) {
			if (strrpos($campaign['name'], $prev) != false) { $result[] = $campaign; }
		}

		return $result;
	}

	public function campaigns_to_ids($campaigns)
	{
		$result = [];

		foreach ($campaigns as $campaign) {
			$result[] = $campaign['campaign_id'];
		}

		return $result;
	}

	public function get_runs()
	{
		$data = [];
		$sql = "SELECT * FROM campaign_runs";
		$stmt = $this->conn->prepare($sql);
		$stmt->execute();
		$result = $stmt->get_result();

		while ( !is_null( $run = $result->fetch_assoc() )) {
			$data[] = $run;
		}
		$stmt->close();

		return $data;
	}

	public function filter_run_by_active($runs)
	{
		$result = [];

		$now = new DateTime("now");

		foreach ($runs as $run) {
			$runStart = new DateTime($run['start']);
			$runEnd = new DateTime($run['end']);

			if ($now >= $runStart && $now <= $runEnd) {
				$result[] = $run;
			}
		}

		return $result;
	}

	public function get_stat_by_run($run_id)
	{
		$sql = "SELECT * FROM learner_run_stats WHERE BINARY run_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $run_id);
		$stmt->execute();

		$result = $stmt->get_result();

		$data = [];

		while ($stat = $result->fetch_assoc()) {
			$data[] = $stat;
		}

		$stmt->close();

		return $data;
	}
	
	public function get_stat_by_run_and_learner($run_id, $learner_id)
	{
		$sql = "SELECT * FROM learner_run_stats WHERE BINARY run_id = ? AND BINARY learner_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ss", $run_id, $learner_id);
		$stmt->execute();

		$result = $stmt->get_result();
		$stat = $result->fetch_assoc();
		$stmt->close();

		return $stat;
	}

	private function insert_stat($stat, $run_id)
	{
		$sql = "INSERT INTO learner_run_stats (learner_id, completed_on, status, run_id) VALUES (?, ?, ?, ?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ssss", $stat->id, $stat->completed_on, $stat->status, $run_id);
		$stmt->execute();
		$stmt->close();
	}

	private function update_stat($stat, $run_id)
	{
		$sql = "UPDATE learner_run_stats SET completed_on = ?, status = ? WHERE BINARY learner_id = BINARY ? AND BINARY run_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ssss", $stat->completed_on, $stat->status, $stat->id, $run_id);
		$stmt->execute();
		$stmt->close();
	}

	protected function get_summary($learner_id, $campaign_id) {
		$sql = "SELECT * FROM learner_run_stats_summary WHERE BINARY learner_id = BINARY ? AND BINARY campaign_id = ?";
		$stmt = $this->conn->prepare($sql);

		$stmt->bind_param("ss", $learner_id, $campaign_id);
		$stmt->execute();

		$result = $stmt->get_result();
		$summary = $result->fetch_assoc();

		$stmt->close();

		return $summary;
	}

	protected function insert_summary($learner_stat, $campaign_id) {
		$completed = 0;

		if ($learner_stat->status == "completed") {
			$completed = 1;
		}

		$sql = "INSERT INTO learner_run_stats_summary (learner_id, campaign_id, completed) VALUES (?, ?, ?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ssi", $learner_stat->id, $campaign_id, $completed);

		$stmt->execute();

		$stmt->close();

		return $this->conn->insert_id;
	}

	protected function update_summary($completed, $id) {
		$sql = "UPDATE learner_run_stats_summary SET completed = ? WHERE id = ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("ii", $completed, $id);
		$stmt->execute();
		$stmt->close();
	}

	protected function insert_or_update_summary($learner_stat, $campaign_id)
	{
		$exists = $this->get_summary($learner_stat->id, $campaign_id);

		if (is_null($exists)) {
			// create new summary record
			$this->insert_summary($learner_stat, $campaign_id);
		} else {
			$completed = 0;

			if ($learner_stat->status == "completed") {
				$completed = 1;
			}

			if ($exists['completed'] != $completed) {
				$this->update_summary($completed, $exists['id']);
			}
		}
	}

	public function insert_run_statistics($data, $run_id, $campaign_id)
	{
		$num = 0;

		foreach ($data as $item) {


			$exists = $this->get_stat_by_run_and_learner($run_id, $item->id);

			$this->insert_or_update_summary($item, $campaign_id);
			
			if (is_null($exists)) {
				$this->insert_stat($item, $run_id);
				$num++;
			} else {
				$this->update_stat($item, $exists['run_id']);
			}
		}

		return $num;
	}

	public function cyrenLogin($clientId, $clientSecret) {
		$ch = curl_init(CYREN_HOST . 'token');

		curl_setopt_array($ch, array(
			CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "grant_type=client_credentials&client_id=$clientId&client_secret=$clientSecret",
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/x-www-form-urlencoded"
            ),
		));

		$response = curl_exec($ch);
		curl_close($ch);
		return json_decode($response);
	}

	public function cyrenButtonData($type, $offset, $days, $token = null)
	{
		$days = intval($days);

		if ($days < 1 || $days > 30) {
			return return_json(['message' => 'Days must be between 1 and 30']);
		}

		$now = new DateTime("now");

		$end = new DateTime("now");
		$end->modify("-1 day");
		$end->setTime(23, 59, 59);

		$start = new DateTime("now");
		$start->modify("-$days day");

		if ($days == 30) {
			$start->setTime(intval($now->format("G")) + 1, 0);
		} else {
			$start->setTime(0, 0, 0);
		}

		// $now = new DateTime("now");
		// $now_milli = $now->getTimestamp() * 1000;

		// $may_1 = new DateTime("now");
		// $may_1->setDate(2022, 7, 2);
		// $may_1_milli = $may_1->getTimestamp() * 1000;

		// $url = "transactions?transaction_type=$type&minutes_back=$minutes_back";
		$url = "transactions?transaction_type=$type&date_from=" . $start->getTimestamp() * 1000 . "&date_to=" . $end->getTimestamp() * 1000 . "&limit=100&offset=$offset";

		$ch = curl_init(CYREN_HOST . $url);

		$authorization = "Authorization: Bearer $token";

		curl_setopt_array($ch, array(
			CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json",
				$authorization
            ),
		));

		$response = curl_exec($ch);
		curl_close($ch);
		return json_decode($response);
	}
	
	private function get_button_data_by_email_subject($email, $subject)
	{
		$sql = "SELECT id, user_email FROM button_data WHERE LOWER(user_email)=LOWER(?) AND LOWER(email_subject)=LOWER(?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param('ss', $email, $subject);
		$stmt->execute();

		$result = $stmt->get_result();

		$button_data = $result->fetch_assoc();

		$stmt->close();

		return $button_data;
	}

	protected function getTotalForLearner($learnerId)
	{
		$stmt = $this->conn->prepare("SELECT id, value, learner_id FROM all_value WHERE BINARY learner_id = BINARY ?");
		$stmt->bind_param('s', $learnerId);

		$stmt->execute();
		$result = $stmt->get_result();

		$allvaue = $result->fetch_assoc();

		$stmt->close();

		return $allvaue;
	}

	protected function createAllValueForLearner($learnerId, $value = 1)
	{
		$sql = "INSERT INTO all_value (value, learner_id) VALUES (?, ?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param('is', $value, $learnerId);
		$stmt->execute();
		$stmt->close();	
	}

	protected function updateLearnerTotalIndicators($learnerId, $value)
	{
		$sql = "UPDATE all_value SET value = ? WHERE BINARY learner_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param('is', $value, $learnerId);
		$stmt->execute();
		$stmt->close();
	}

	protected function saveAllValues($all)
	{
		foreach ($all as $key => $item) {
			if ($key != "") {
				$totalForLearner = $this->getTotalForLearner($key);

				if (is_null($totalForLearner)) {
					// create all value for learner with initial value of 1 
					$this->createAllValueForLearner($key, $item);
				} else {
					// increase existing total by 1
					$this->updateLearnerTotalIndicators($key, $totalForLearner['value'] + $item);
				}
			}
		}
	}

	public function saveCyrenButtonDataToDb($data)
	{
		$num = 0;

		$all_values = array();

		foreach ($data as $item) {
			$user_email = $item->user_email;
			// get learner id
			$learner = $this->get_learner_by_email($user_email);

			if (is_null($learner)) {
				$not_found[] = array('email' => strtolower($user_email), 'name' => $item->user_name, 'connection_name' => $item->connection_name);
			}

			$learnerId = $learner['learner_id'];

			// save button data accordingly
			$case = $item->case_id;

			$stmt = null;

			$indicators = 0;

			if (!is_null($item->indicators)) {
				foreach ($item->indicators as $indicator) {
					if (strtolower($indicator->description) == "infosec - security awareness training") {
						$indicators += 1;
					} 
				}
			}
			

			if ($case == "") {
				// make user there is no record with same global_tx_id and processed_at field
				$exists = $this->get_button_data_by_email_subject($item->user_email, $item->email->subject);

				if (!is_null($exists)) 
					continue;

				$stmt = $this->conn->prepare("INSERT INTO button_data (application_type, tenant_id, organization_id, organization_name, connection_name, user_email, user_name, transaction_type, classification, incident_id, processed_at, global_tx_id, indicators, email_subject) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
				$stmt->bind_param('ssssssssssssis', $item->application_type, $item->tenant_id, $item->organization_id, $item->organization_name, $item->connection_name, $item->user_email, $item->user_name, $item->transaction_type, $item->classification, $item->incident_id, $item->processed_at, $item->global_tx_id, $indicators, $item->email->subject);
			} else {
				$stmt = $this->conn->prepare("INSERT INTO button_data (application_type, tenant_id, organization_id, organization_name, connection_name, user_email, user_name, transaction_type, classification, case_id, incident_id, processed_at, global_tx_id, indicators, email_subject) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
				$stmt->bind_param('sssssssssssssis', $item->application_type, $item->tenant_id, $item->organization_id, $item->organization_name, $item->connection_name, $item->user_email, $item->user_name, $item->transaction_type, $item->classification, $case, $item->incident_id, $item->processed_at, $item->global_tx_id, $indicators, $item->email->subject);
			}
			
			if ($stmt->execute()) {

				if (strtolower($item->transaction_type) == "button_feedback") {
					if (!is_null($item->indicators)) {
						$hasSim = false;

						foreach($item->indicators as $indicator) {
							if (strtolower($indicator->description) == "infosec - security awareness training") {
								$hasSim = true;
								break;
							}
						}	

						if ($hasSim == false) {
							if (isset($all_values[$learnerId])) {
								$all_values[$learnerId] += 1;
							} else {
								$all_values[$learnerId] = 1;
							}
						}
					} else {
						if (isset($all_values[$learnerId])) {
							$all_values[$learnerId] += 1;
						} else {
							$all_values[$learnerId] = 1;
						}
					}
				}

				$num += 1;
			} else {
				continue;
			}
		
			$stmt->close();
		}

		// save all values
		$this->saveAllValues($all_values);

		return $num;
	}

	private function get_stats_by_run($run_id)
	{
		$sql = "SELECT s.learner_id, s.status, l.email, l.first_name, l.last_name FROM learner_run_stats s JOIN learners l ON BINARY s.learner_id = BINARY l.learner_id WHERE BINARY run_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $run_id);
		$stmt->execute();

		$result = $stmt->get_result();

		$data = [];
		while (!is_null($item = $result->fetch_assoc())) {
			$data[] = $item;
		}

		$stmt->close();

		return $data;
	}

	public function get_company_by_learner($learner_id)
	{
		$sql = "SELECT c.name FROM learners l JOIN companies c ON l.company = c.id WHERE BINARY l.learner_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $learner_id);
		$stmt->execute();

		$result = $stmt->get_result();
		$company = $result->fetch_assoc();

		$stmt->close();

		return $company;
	}

	public function get_runs_by_campaign($name)
	{
		$sql = "SELECT * FROM campaign_runs WHERE BINARY campaign_id = BINARY ?";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param("s", $name);
		$stmt->execute();

		$result = $stmt->get_result();

		$data = [];

		while (!is_null( $item = $result->fetch_assoc() )) {
			$data[] = $item;
		}

		$stmt->close();

		return $data;
	}

	private function getButtonDataEmailsForCompany($company_name) {
		$sql = "SELECT l.learner_id, l.email, l.first_name, l.last_name FROM companies c JOIN learners l ON c.id=l.company WHERE LOWER(c.name)=LOWER(?)";
		$stmt = $this->conn->prepare($sql);
		$stmt->bind_param('s', $company_name);
		$stmt->execute();
		$result = $stmt->get_result();

		$data = [];

		while (!is_null($item = $result->fetch_assoc())) {
			$data[] = $item;
		}

		$stmt->close();
		return $data;
	}

	protected function getButtonDataByEmail($email) {
		$sql = "SELECT id, processed_at, indicators FROM button_data WHERE LOWER(user_email)=LOWER('$email')";

		$result = $this->conn->query($sql);

		$data = [];

		while ($row = $result->fetch_row()) {
		    $data[] = array(
		    						'id'				=> $row[0],
									'processed_at'		=> $row[1],
									'indicators' 		=> $row[2]
		    					);
		}

		return $data;
	}

	protected function getForPreviousMonth($buttondata)
	{
		$now = new DateTime("now");
    	$currentMonth = (int) $now->format('m');

	 	$buttondata = array_filter($buttondata, function ($obj) use ($currentMonth) {
			$month = (int) date('m', strtotime($obj['processed_at']));

			return $month == $currentMonth - 1;
		});
		
		return $buttondata;
	}

	public function run_mail($campaignType)
	{
		$campaigns = $this->fetch_campaigns_by_type($campaignType);
		$campaigns = $this->filter_campaigns_by_prev_month($campaigns);

		foreach ($campaigns as $campaign) {
			$runs = $this->get_runs_by_campaign($campaign['campaign_id']);
			// $runs = $this->filter_run_by_active($runs);
			$campaign_name = $campaign['name'];
			
			$result = [];

			foreach ($runs as $run) {
				$run_stats = $this->get_stats_by_run($run['run_id']);
				$start_date = date("m/d/Y", strtotime($run['start']));
				
				foreach ($run_stats as $stat) {
					// if ($stat['status'] == "completed") continue;

					$company = $this->get_company_by_learner($stat['learner_id']);

					if (is_null($company)) continue;

					$company_name = $company['name'];

					if (!isset($result[$company_name]) || is_null($result[$company_name])) {
						$result[$company_name] = array(
							'learners' => [
								array('learner_id' => $stat['learner_id'], 'status' => $stat['status'], 'email' => $stat['email'], 'full_name' => $stat['first_name']. " ". $stat['last_name']),
							],
							'startDate' => $start_date,
						);
					} else {
						$learners = $result[$company_name]['learners'];
						$learners[] = array('learner_id' => $stat['learner_id'], 'status' => $stat['status'], 'email' => $stat['email'], 'full_name' => $stat['first_name']. " ". $stat['last_name']);
						$result[$company_name]['learners'] = $learners;
					}
				}

			}

			if (empty($result)) {
				$companies = $this->get_companies();

				foreach ($companies as $company) {
					$emailAndNameOfContact = $this->getEmailAndNameOfContact($company['name']);
					$button_data_users = $this->getButtonDataEmailsForCompany($company['name']);
					$subject = "Security Awareness Training - ". $company['name'] . " - $campaign_name";
					$rowData = '';
					
					$campaigns = [];

					foreach($button_data_users as $button_data) {
							$campaigns[] = array(
								'email'			=> $button_data['email'],
								'full_name'		=> $button_data['first_name']. " " .$button_data['last_name'],
								'learner_id'	=> $button_data['learner_id']
							);
					}

					if (empty($campaigns)) {
						continue;
					}

					foreach ($campaigns as $campaign) {
						$user_email = $campaign['email'];
						$buttondata = $this->getButtonDataByEmail($user_email);

						// filter button data for previous month

						// $buttondata = $this->getForPreviousMonth($buttondata); // Comment out to disable month filter

						$simulationsIdentified = 0;
						$total = 0;

						$totalForLearner = $this->getTotalForLearner($campaign['learner_id']);
						if (is_null($totalForLearner) == false) $total = $totalForLearner['value']; 

						if (empty($buttondata) == false) {
							foreach ($buttondata as $data) {
								$simulationsIdentified += (int) $data['indicators'];
							}
						}
						
						$rowData .= "<tr>";
						$rowData .= "<td>" . $campaign['full_name'] . "</td>";
						$rowData .= "<td>Not Started</td>";
						$rowData .= "<td>" . $simulationsIdentified . "</td>";
						$rowData .= "<td>" . $total . "</td>";
						$rowData .= "</tr>";
					}

					$data = [];
					$data['rows'] = $rowData;
					$data['campaignName'] = $campaign_name;
					$data['campaignStart'] = "";

					$this->sendMail($subject, $data, $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact'], MAIL_TEMPLATE); 
				}
			} else {
				foreach ($result as $key => $item) {
					//if ($key == "Myers, Widders, Gibson Jones & Feingold, LLP") {
						// $key is name of company
						$emailAndNameOfContact = $this->getEmailAndNameOfContact($key);

						$subject = "Security Awareness Training - ". $key . " - $campaign_name";
						$rowData = '';

						$stats = $item['learners'];

						if (empty($stats)) {
							continue;
						}

						foreach ($stats as $stat) {
							$user_email = $stat['email'];
							$buttondata = $this->getButtonDataByEmail($user_email);

							// filter button data for previous month

							// $buttondata = $this->getForPreviousMonth($buttondata); // Comment out to disable month filter

							$simulationsIdentified = 0;
							$total = 0;

							$totalForLearner = $this->getTotalForLearner($stat['learner_id']);
							if (is_null($totalForLearner) == false) $total = $totalForLearner['value']; 

							if (empty($buttondata) == false) {
								foreach ($buttondata as $data) {
									$simulationsIdentified += (int) $data['indicators'];
								}
							}

							$status = "Not Started";

							if (!is_null($stat['status']) && $stat['status'] == "completed") $status = "Completed";

							$rowData .= "<tr>";
							// $rowData .= "<td>" . $campaignName . "</td>"; 
							// $rowData .= "<td>" . $item['startDate'] . "</td>";
							$rowData .= "<td>" . $stat['full_name'] . "</td>";
							$rowData .= "<td>$status</td>";
							$rowData .= "<td>" . $simulationsIdentified . "</td>";
							$rowData .= "<td>" . $total . "</td>";
							$rowData .= "</tr>";
						}


						$this->sendMail($subject, ['rows' => $rowData, 'campaignName' => $campaign_name, 'campaignStart' => $item['startDate']], $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact'], MAIL_TEMPLATE); 
					//}
				}
			}
		}

		return 'Finish...';
	}

	public function findEventDbID($campaignId, $learnerId, $templateId, $type) {
		$sql = "SELECT id, campaign_id, learner_id FROM events WHERE BINARY campaign_id = BINARY ? AND BINARY learner_id = BINARY ? AND BINARY template_id = BINARY ? AND type_from_api = ?";
		$stmt = $this->conn->prepare($sql);

		$stmt->bind_param("ssss", $campaignId, $learnerId, $templateId, $type);
		$stmt->execute();

		$result = $stmt->get_result();

		return $result->fetch_assoc();
	}
}

?>