<?php

require "../bootstrap.php";

try {
    $campaigns = $Processor->get_campaigns();
    $campaigns = $Processor->filter_campaign_by_current_month($campaigns);
    $campaignIds = $Processor->campaigns_to_ids($campaigns);

    $lastday = new DateTime("now");
    $lastday->modify("-1 day");
    $lastday->setTime(23, 59, 59);
    $lastday = $lastday->format("Y-m-d H:i:s");

    $firstday = new DateTime("now");
    $firstday->modify("-1 day");
    $firstday->setTime(0, 0, 0);
    $firstday = $firstday->format("Y-m-d H:i:s");

    $timelines = 0;

    $page = 1;

    $toSave = 0;
    $total = 0;

    $response_data = $Processor->request("timeline-events?limit=100&page=$page&start=$firstday&end=$lastday");

    while (isset($response_data->data) && !is_null($response_data->data)) {

        $response = $response_data->data;

        $total += count($response);

        foreach ($response as $event) {

            if (in_array($event->campaign_id, $campaignIds)) {
                $eventType = "";

                switch ($event->type) {
                    case 'phished-learner':
                        $eventType = 'Phished';
                        break;
                    case 'entered-data':
                        $eventType = 'Phished & Entered Data';
                        break;
                    case 'opened-attachment':
                        $eventType = 'Phished & Opened Attachment';
                        break;
                    case 'enabled-macro':
                        $eventType = 'Phished & Enabled Macro';
                        break;
                    case 'replied':
                        $eventType = 'Phished & Replied';
                        break;
                    case 'sent-phish-email':
                        $eventType = 'Sent Phish Email';
                        break;
                    default:
                        $eventType = $event->type;
                        break;
                }

                $dt = new DateTime($event->timestamp);
                $timestamp = $dt->format('Y-m-d H:i:s');

                $exist = $Processor->findEventDbID($event->campaign_id, $event->learner_id, $event->template_id, $event->type);

                if ($exist == false || is_null($exist) || empty($exist)) {
                    $templateName = '';
                    if ($event->template_id != null) {
                        $template = $Processor->request("templates/" . $event->template_id);
                        if (!empty($template))
                            $templateName = $template->name;
                    }

                    // save event
                    $Processor->insert_event($event, $eventType, $timestamp, $templateName);

                    $toSave++;
                }
            }
        }

        $page++;

        $response_data = $Processor->request("timeline-events?limit=100&page=$page&start=$firstday&end=$lastday");
    }

    return return_json(["message" => "Finished..."]);

} catch (Exception $e) {
    return return_json(["error" => $e->getMessage() . ' at line ' . $e->getLine()]);
}