<?php
/**
 * api -> run
 * 
 * @package InfoSec API
 * @author Fahd Saeed (fahds@fluidnets.com)
 */

// Fetch bootstrap file
require '../bootstrap.php';

//is_ajax();

$NUM_OF_DAYS_BACK = 1; // NUMBER OF DAYS BACK TO FETCH DATA FOR. MAX IS 30. MIN IS 1

try {
    $cyrenCreds = CYREN;

    $num = 0;

    foreach ($cyrenCreds as $cred) {
        // Fetch the Authentication Token
        // $token = $Processor->cyrenLogin($cred['client_id'], $cred['client_secret'])->data->access_token;
        $token = $Processor->cyrenLogin($cred['client_id'], $cred['client_secret']);
        return return_json($token);

        $data = [];
        $offset = 0;
        $button_data = $Processor->cyrenButtonData("button_feedback", $offset, $NUM_OF_DAYS_BACK, $token);

        while (isset($button_data->data) && !is_null($button_data->data)) {
            $data = array_merge($data, $button_data->data);
            $offset += 100;
            $button_data = $Processor->cyrenButtonData("button_feedback", $offset, $NUM_OF_DAYS_BACK, $token);
        }

        $offset = 0;
        $button_data = $Processor->cyrenButtonData("button_scan", $offset, $NUM_OF_DAYS_BACK, $token);
        while (isset($button_data->data) && !is_null($button_data->data)) {
            $data = array_merge($data, $button_data->data);
            $offset += 100;
            $button_data = $Processor->cyrenButtonData("button_scan", $offset, $NUM_OF_DAYS_BACK, $token);
        }

        $num += $Processor->saveCyrenButtonDataToDb($data);
    }

    if ($num == 0)
        $Processor->notifyNoDataSaved();

    return return_json(['success' => true, 'message' => "$num number of button data saved"]);

} catch (Exception $e) {
    return_json(['error' => $e->getMessage() . ' at line ' . $e->getLine()]);
}