<?php 

require '../bootstrap.php';

try {
    $months = $Processor->get_previos_months();

    $companies = $Processor->get_companies();

    $campaigns = $Processor->get_campaigns();

    $filteredCampaigns = [];

    $runs = [];

    foreach ($campaigns as $campaign) {
        $array = explode(" ", $campaign['name']);

        if (in_array($array[1], $months) && $campaign['type'] == "awareness") {
            $filteredCampaigns[] = $campaign['campaign_id'];
            $campaignRuns = $Processor->get_runs_by_campaign($campaign['campaign_id']);

            $runs = array_merge($runs, $campaignRuns);
        }
    }

    $result = [];

    foreach ($runs as $run) {
        $startDate = date("m/d/Y", strtotime($run->start));

        $learner_stats = $Processor->get_stat_by_run($run['run_id']);

        if (empty($learner_stats)) continue;

        foreach ($learner_stats as $stat) {
            $learnerId = $stat['learner_id'];

            $company = $Processor->get_company_by_learner($learnerId);

            if (is_null($company)) continue;

            $companyName = $company['name'];

            if($result[$companyName] == null) {
                $result[$companyName] = array('learnerIds' => "$learnerId", 'startDate' => $startDate );
            } else {
                $learnerIds = $result[$companyName]['learnerIds'] . ",$learnerId";
                $result[$companyName] = array('learnerIds' => $learnerIds, 'startDate' => $startDate);
            }
        }
    }

    foreach ($result as $key => $item) {
        $emailAndNameOfContact = $Processor->getEmailAndNameOfContact($key);
        $subject = "Security Awareness Training - ". $key . " - Top Learners";
        $rowData = '';

        $learners = $Processor->get_learners_from_list($item['learnerIds']);

        foreach ($learners as $learner) {
            $summaries = $Processor->get_summary_by_learner($learner['learner_id']);

            $total = 0;
            $completed = 0;
            
            foreach ($summaries as $summary) {
                if (in_array($summary['campaign_id'], $filteredCampaigns)) {
                    $total += 1;

                    if ($summary['completed'] == 1) {
                        $completed += 1;
                    } 
                }
            }

            $score = ($completed / $total) * 100;
            $score = round($score);

            if ($score < 90) continue;

            $rowData .= "<tr>";
            $rowData .= "<td>" . $learner['first_name'] . 	"</td>";
            $rowData .= "<td>" . $learner['last_name']  . 	"</td>";
            $rowData .= "<td>" . $learner['department'] . 	"</td>";
            $rowData .= "<td>" . $score .  "%</td>";
            if($score == 100) {
                $rowData .= "<td><img width='16' height='16' src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAABL1BMVEUAAAD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD///8Jrm9iAAAAY3RSTlMAAAAAAAAAAAAAHBwDlpYDNOnpNAKVlQIBCBNH5+dHEwgBCmmeutTs/+y6nmkJBoj7+4cGCof4+IYKCYL394EJD8XFDxbU1BYu6/XrLk7697VMTLX3+k5fvlQMDFS+Xg4ODg7MC7G8AAAAAWJLR0Rkwtq4CQAAAAd0SU1FB+UFBAg5FNeSMMkAAAC2SURBVBjTY2AAAUYmLm4mZgYEYOHh5eNnQvBZ2QQEhYRZ2OECHCKiycli4hwQHpOEpJS0THKyrJy8giInA4OSsoqqmrpGcrKGppqWto4ug56+QTIcGBoZMzCZmJrB+OYWlkA9TFbWNhC+rZ092GoWB0eIgJMzJ8RVLq4QATd3FrAAm4dncrKXV3Kytw9EgMXXzz8gMCg4JDQMKhAeERnFxhYdExsHEWCKT+AEupqFKTGJhQETAADFbiXPxGSZNQAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMS0wNS0wNFQwODo1NzoyMC0wNDowMCOZ1G4AAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjEtMDUtMDRUMDg6NTc6MjAtMDQ6MDBSxGzSAAAAAElFTkSuQmCC'/></td>";
            } else {
                $rowData .= "<td></td>";
            }
            $rowData .= "</tr>";
        }

        if($rowData == '') {
			continue;
		}

        $Processor->sendMail($subject, $rowData, $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact'], MAIL_SUMMARY_TEMPLATE); 
    }


    return "Finish...";
} catch (Exception $e) {
    return return_json(['error' => $e->getMessage().' at line '.$e->getLine()]);
}

?>