<?php 
set_time_limit(0);
define("STATUS_NOT_STATED",     "not_started");
define("STATUS_COMPLETED",     "completed");
define("MAIL_SUMMARY_TEMPLATE",     "summary");
define("MAIL_PHISHING_TEMPLATE",     "phishing");
define("MAIL_TEMPLATE",     "normal");

class Processor {
	private $campaigns = [];
	private $companies = [];
	private $data = [];
	private $conn = null;

	function __construct() {
		$this->conn = new mysqli(DB_SERVER_NAME, DB_USERNAME, DB_PASSWORD, DB_NAME);
	}

	public function test() {
		$sql = "DELETE FROM temp";
		$this->conn->query($sql);
		$this->campaigns = $this->request("campaigns?limit=100")->data;
		
		foreach ($this->campaigns as $campaign) {
			if(!$this->strpos_arr($campaign->name, $this->getPreviosMonths())) {
				continue;
			}
			$runs = $this->request("campaigns/{$campaign->id}/runs?limit=100")->data;
			if(empty($runs)) {
				continue;
			}
			foreach ($runs as $key => $run) {
				$resultLearns = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=1&limit=100");

				$learners = $resultLearns->data;
				$pageCount = $resultLearns->meta->pageCount;
				
				for ($i = 0; $i <= $pageCount; $i++) {

					if($i > 1) {
						$learners = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=" . $i . "&limit=100")->data;
					}
					if(empty($learners)) {
						continue;
					}
					foreach ($learners as $learner) {
						
						$user = $this->request("learners/{$learner->id}" );
						$first_name = str_replace("'", "\'", $user->first_name);
						$last_name = str_replace("'", "\'", $user->last_name);

						$sql = "INSERT INTO temp(CAMPAIGN_ID,CAMPAIGN_NAME,RUN_ID,LEARNER_ID,FIRST_NAME,LAST_NAME,EMAIL,STATUS) VALUES('$campaign->id', '$campaign->name', '$run->id', '$learner->id', '$first_name', '$last_name', '$user->email', '$learner->status')";
						$this->conn->query($sql);
					}
				}

			}
		}

		return 'DONE.';
	}

	public function runMailSummary($campaignType) {
		$months = $this->getPreviosMonths();
		$companies = $this->getCompanies();

		$campaigns = $this->request("campaigns?limit=100")->data;
		$campaignName = '';
		if(empty($campaigns)) {
			return 'campaign not found.';
		}
		foreach ($campaigns as $campaign) {
			if($this->strpos_arr($campaign->name, $months) && $campaign->type == $campaignType) {
				$campaignName = $campaign->name;
				$runs = $this->request("campaigns/{$campaign->id}/runs?limit=100")->data;

				foreach ($runs as $run) {
					$startDate = date("m/d/Y", strtotime($run->start));
					$resultLearns = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=1&limit=100");
					
					$learners = $resultLearns->data;
					$pageCount = $resultLearns->meta->pageCount;

					for ($i = 0; $i <= $pageCount; $i++) {

						if($i > 1) {
							$learners = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=" . $i . "&limit=100")->data;
						}
						if (empty($learners)) continue;
						foreach ($learners as $learner) {

							$companyId = $this->getCompanyByLearner($learner->id);
							$companyName = $this->getCompanyNameById($companies, $companyId);
							if($companyName == '' || $companyName == null) {
								continue;
							}
							$learnerDbID = $this->getLearnerDbID('campaigns', $learner->id);
							
							if($result[$companyName] == null) {
								$result[$companyName] = array(
																'leanerIds' => "$learnerDbID",
																'startDate' => $startDate
															);
							} else {
								$leanerIds = $result[$companyName]['leanerIds'] . ",$learnerDbID";
								$result[$companyName] = array(
																'leanerIds' => $leanerIds,
																'startDate' => $startDate
															);
							}
						}
					}
				}


			}
		}
		foreach ($result as $key => $item) {
			$emailAndNameOfContact = $this->getEmailAndNameOfContact($key);
			$subject = "Security Awareness Training - ". $key . " - Top Learners";
			$rowData = '';
			
			$campaigns = $this->getCampaignsByCompany($item['leanerIds'], true);
			if(empty($campaigns)) {
				continue;
			}
			foreach ($campaigns as $campaign) {

				if($campaign['PROGRESS_COMPLETED'] < 90) {
					continue;
				}
				
				$rowData .= "<tr>";
				$rowData .= "<td>" . $campaign['FIRST_NAME'] . 	"</td>";
				$rowData .= "<td>" . $campaign['LAST_NAME']  . 	"</td>";
				$rowData .= "<td>" . $campaign['DEPARTMENT'] . 	"</td>";
				$rowData .= "<td>" . intval($campaign['PROGRESS_COMPLETED']) .  "%</td>";
				if($campaign['PROGRESS_COMPLETED'] == 100) {
					$rowData .= "<td><img width='16' height='16' src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAABL1BMVEUAAAD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD/5QD///8Jrm9iAAAAY3RSTlMAAAAAAAAAAAAAHBwDlpYDNOnpNAKVlQIBCBNH5+dHEwgBCmmeutTs/+y6nmkJBoj7+4cGCof4+IYKCYL394EJD8XFDxbU1BYu6/XrLk7697VMTLX3+k5fvlQMDFS+Xg4ODg7MC7G8AAAAAWJLR0Rkwtq4CQAAAAd0SU1FB+UFBAg5FNeSMMkAAAC2SURBVBjTY2AAAUYmLm4mZgYEYOHh5eNnQvBZ2QQEhYRZ2OECHCKiycli4hwQHpOEpJS0THKyrJy8giInA4OSsoqqmrpGcrKGppqWto4ug56+QTIcGBoZMzCZmJrB+OYWlkA9TFbWNhC+rZ092GoWB0eIgJMzJ8RVLq4QATd3FrAAm4dncrKXV3Kytw9EgMXXzz8gMCg4JDQMKhAeERnFxhYdExsHEWCKT+AEupqFKTGJhQETAADFbiXPxGSZNQAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMS0wNS0wNFQwODo1NzoyMC0wNDowMCOZ1G4AAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjEtMDUtMDRUMDg6NTc6MjAtMDQ6MDBSxGzSAAAAAElFTkSuQmCC'/></td>";
				} else {
					$rowData .= "<td></td>";
				}
				$rowData .= "</tr>";
					
				// BEGIN TEST 	
				// $this->sendMail($subject, $rowData, $toEmail, $nameOfContact, MAIL_SUMMARY_TEMPLATE); 
				// return;
				// END TEST
			}

			if($rowData == '') {
				continue;
			}
			$this->sendMail($subject, $rowData, $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact'], MAIL_SUMMARY_TEMPLATE); 
		}

		return 'Finish...';
	}

	public function runMail($campaignType) {

		$companies = $this->getCompanies();

		$campaigns = $this->request("campaigns?limit=100")->data;
		$campaignName = '';
		foreach ($campaigns as $campaign) {
			if($this->strpos_arr($campaign->name, $this->getCurrentMonth()) && $campaign->type == $campaignType) {
				$campaignName = $campaign->name;
				$runs = $this->request("campaigns/{$campaign->id}/runs?limit=100")->data;

				foreach ($runs as $run) {
					$startDate = date("m/d/Y", strtotime($run->start));
					$resultLearns = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=1&limit=100");
					
					$learners = $resultLearns->data;
					$pageCount = $resultLearns->meta->pageCount;
					// $pageCount = 1;

					for ($i = 0; $i <= $pageCount; $i++) {

						if($i > 1) {
							$learners = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=" . $i . "&limit=100")->data;
						}
						if (empty($learners)) continue;
						foreach ($learners as $learner) {

							$companyId = $this->getCompanyByLearner($learner->id);
							$companyName = $this->getCompanyNameById($companies, $companyId);
							if($learner->status == 'completed' || $companyName == '' || $companyName == null) {
								continue;
							}
							$learnerDbID = $this->getLearnerDbID('campaigns', $learner->id);
							
							if($result[$companyName] == null) {
								$result[$companyName] = array(
																'leanerIds' => "$learnerDbID",
																'startDate' => $startDate
															);
							} else {
								$leanerIds = $result[$companyName]['leanerIds'] . ",$learnerDbID";
								$result[$companyName] = array(
																'leanerIds' => $leanerIds,
																'startDate' => $startDate
															);
							}
						}
					}
				}


			}
		}

		if($result == null) {
			return 'Data not found';
		}
		foreach ($result as $key => $item) {
			$emailAndNameOfContact = $this->getEmailAndNameOfContact($key);
			$subject = "Security Awareness Training - ". $key . " - Not Completed";
			$rowData = '';
			$campaigns = $this->getCampaignsByCompany($item['leanerIds'], false);
			
			if (empty($campaigns)) {
				continue;
			}

			foreach ($campaigns as $campaign) {
				
				$rowData .= "<tr>";
				$rowData .= "<td>" . $campaignName . "</td>";
				$rowData .= "<td>" . $item['startDate'] . "</td>";
				$rowData .= "<td>" . $campaign['FULL_NAME'] . "</td>";
				$rowData .= "<td>Not Started</td>";
				$rowData .= "</tr>";
			}
			$this->sendMail($subject, $rowData, $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact'], MAIL_TEMPLATE); 
		}

		return 'Finish...';
	}

	public function runMailPhishing() {
		$companies = $this->getCompanies();
		$this->campaigns = $this->request("campaigns?limit=100")->data;
		foreach ($this->campaigns as $campaign) {
			if($this->strpos_arr($campaign->name, $this->getCurrentMonth())) {
				$campaignIds[] = $campaign->id;
			}
		}

		
		$resultEvents = $this->request("timeline-events?page=1&limit=100");

		// return $resultEvents;
		$events = $resultEvents->data;
		$pageCount = $resultEvents->meta->pageCount;

		// TEST
		// $pageCount = 10;
		// END TEST

		for ($i = 0; $i <= $pageCount; $i++) {

			if($i > 1) {
				$events = $this->request("timeline-events?page=" . $i . "&limit=100")->data;
			}
			if (empty($events)) continue;
			foreach ($events as $event) {
				if (!in_array($event->campaign_id, $campaignIds)) continue;
				$types = array('phished-learner', 'entered-data', 'opened-attachment', 'enabled-macro', 'replied', 'matched-pattern');
				if (!in_array($event->type, $types)) continue;

				$companyId = $this->getCompanyByLearner($event->learner_id);
				$companyName = $this->getCompanyNameById($companies, $companyId);
				if($companyName == '' || $companyName == null) {
					continue;
				}
				$eventDbID = $this->findEventDbID2($event->campaign_id, $event->learner_id, $event->template_id);
				if($eventDbID == null) continue;
				if($result[$companyName] == null) {
					$result[$companyName] = array(
													'eventIds' => "$eventDbID",
												);
				} else {
					$eventIds = $result[$companyName]['eventIds'] . ",$eventDbID";
					$result[$companyName] = array(
													'eventIds' => $eventIds,
												);
				}

			}
		}	

		// return $result;
		
		if($result == null) {
			return 'Data not found';
		}
		foreach ($result as $key => $item) {
			
			$subject = "Security Awareness - ". $key . " - Phished Users";
			$rowData = '';
			$events = $this->getEvents($item['eventIds']);
			// return $events;
			$emailAndNameOfContact = $this->getEmailAndNameOfContact($key);
			if (empty($events)) {
				continue;
			}

			foreach ($events as $event) {
				
				$rowData .= "<tr>";
				$rowData .= "<td>" . $event['CAMPAIGN_NAME'] . "</td>";
				$rowData .= "<td>" . $event['FULL_NAME'] . "</td>";
				$rowData .= "<td>" . $event['DATE_IT_OCCURED'] . "</td>";
				$rowData .= "<td>" . $event['TYPE'] . "</td>";
				$rowData .= "<td>" . $event['TEMPLATE_NAME'] . "</td>";
				$rowData .= "</tr>";
			}

			$this->sendMail($subject, $rowData, $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact'], MAIL_PHISHING_TEMPLATE); 
		}

		return 'Send Mail Phishing Finish...';
	}


	private function getEmailAndNameOfContact($companyName) {
		switch ($companyName) {
			case 'Recycled Aggregate Materials Company, Inc':
				$toEmail = 'er@ramco.us.com';
				$nameOfContact = 'Ernest';
				break;
			case 'Myers, Widders, Gibson Jones & Feingold, LLP':
				$toEmail = 'dmpoole@mwgjlaw.com';
				$nameOfContact = 'Myers';
				break;
			case 'Lee & Associates - Oakland':
				$toEmail = 'wsage@lee-associates.com';
				$nameOfContact = 'Wendy';
				break;
			case 'Lee & Associates - Pleasanton':
				$toEmail = 'mschweickert@lee-associates.com';
				$nameOfContact = 'Megan';
				break;
			case 'Holland Electronics, LLC':
				$toEmail = 'tammy@hollandelectronics.com, timr@fluidnets.com';
				$nameOfContact = 'Tammy';
				break;
			case 'Lee & Associates - Riverside':
				$toEmail = 'irios@leeriverside.com';
				$nameOfContact = 'Irma';
				break;
			case 'Lee & Associates - Pasadena':
				$toEmail = 'klbyrne@lee-associates.com';
				$nameOfContact = 'Kasey';
				break;
			case 'Lee & Associates - Investment Services Group':
				$toEmail = 'fahds@fluidnets.com';
				$nameOfContact = 'Fahd';
				break;
			case 'Lee & Associates - LA North/Ventura':
				$toEmail = 'nyoshimi@lee-re.com';
				$nameOfContact = 'Nanette';
				break;	
			case 'Fluid Networks':
				$toEmail = 'ericf@fluidnets.com';
				$nameOfContact = 'Eric';
				break;
				case 'Kern Regional Center':
					$toEmail = 'fbesnard@kernrc.org, twolfgram@kernrc.org';
					$nameOfContact = 'Tom';
					break;
			case 'Pharmaceutic Litho & Label Company, Inc.':
				$toEmail = 'brian.burke@pharmlitho.com,matt.schultz@pharmlitho.com';
				$nameOfContact = 'Brian';
				break;
			case 'LTC Properties, Inc.':
					$toEmail = 'sebastian.deschepper@ltcreit.com';
					$nameOfContact = 'Sebastian';
					break;
			default:
				$toEmail = 'fahdsaeed87@gmail.com';
				$nameOfContact = 'Fahd';
				break;
		}

		return array('toEmail' => $toEmail, 'nameOfContact' => $nameOfContact);
	}
	private function getEvents($eventIds) {
		$sql = "SELECT e.CAMPAIGN_ID, c.FIRST_NAME, c.LAST_NAME, e.DATE_IT_OCCURED, e.TYPE, e.ID, e.LEARNER_ID, e.TEMPLATE_ID, e.TEMPLATE_NAME FROM events e
				INNER JOIN campaigns c ON e.LEARNER_DB_ID=c.ID
				WHERE e.ID IN ($eventIds) ORDER BY c.LAST_NAME";

		$result = $this->conn->query($sql);


		while ($row = $result->fetch_row()) {
			$campaignId =$row[0];
			$key = array_search($campaignId, array_column($this->campaigns, 'id'));

		    $events[] = array(
		    						'CAMPAIGN_ID'			=> $campaignId,	
		    						'CAMPAIGN_NAME'			=> $this->campaigns[$key]->name,
		    						'FULL_NAME' 			=> $row[1] . ' ' . $row[2], 
		    						'FIRST_NAME' 			=> $row[1],
		    						'LAST_NAME' 			=> $row[2],
		    						'DATE_IT_OCCURED'		=> date("m/d/Y", strtotime($row[3])),
		    						'TYPE' 					=> $row[4],
		    						'ID' 					=> $row[5],
		    						'LEARNER_ID' 			=> $row[6],
		    						'TEMPLATE_ID'			=> $row[7],
		    						'TEMPLATE_NAME'			=> $row[8]
		    					);
		}

		return $events;
	}

	public function runSummary($campaignType, $runType){
		$this->run($campaignType, $runType);
	}

	public function runPhishing() {
		$this->campaigns = $this->request("campaigns?limit=100")->data;
		
		$months = $this->getPreviosMonths();
		// print_r($months);
		// die();
		foreach ($this->campaigns as $campaign) {
			if($this->strpos_arr($campaign->name, $months)) {
				$campaignIds[] = $campaign->id;
			}
		}

		// return $campaignIds;
		$resultEvents = $this->request("timeline-events?page=1&limit=100");

		// return $resultEvents;
		$events = $resultEvents->data;
		$pageCount = $resultEvents->meta->pageCount;
		// TEST
		// $pageCount = 3;
		// END TEST
		for ($i = 0; $i <= $pageCount; $i++) {
			if($i > 1) {
				$events = $this->request("timeline-events?page=" . $i . "&limit=100")->data;
			}

			foreach ($events as $key => $event) {
				// TEST
				// $sql = "INSERT INTO events_temp(CAMPAIGN_ID,LEARNER_ID,TYPE, TEMPLATE_ID) VALUES('$event->campaign_id', '$event->learner_id','$event->type', '$event->template_id')";
				// $this->conn->query($sql);
				// continue;
				// END TEST

				if (in_array($event->campaign_id, $campaignIds)) {
					
					switch ($event->type) {
						case 'phished-learner':
							$eventType = 'Phished';
							break;
						case 'entered-data':
							$eventType = 'Phished & Entered Data';
							break;
						case 'opened-attachment':
							$eventType = 'Phished & Opened Attachment';
							break;
						case 'enabled-macro':
							$eventType = 'Phished & Enabled Macro';
							break;
						case 'replied':
							$eventType = 'Phished & Replied';
							break;
						case 'sent-phish-email':
							$eventType = 'Sent Phish Email';
							break;
						default:
							$eventType = $event->type;
							break;
					}
					
					$dt = new DateTime($event->timestamp);
					$timestamp = $dt->format('Y-m-d H:i:s');
					$templateName = '';
					if($event->template_id != null) {
						$template = $this->request("templates/" . $event->template_id);
						if(!empty($template))
							$templateName = $template->name;
					} 

					$eventDbID = $this->findEventDbID($event->campaign_id, $event->learner_id, $event->template_id, $event->type);
					
					if(empty($eventDbID)) {
						$learnerDbID = $this->getLearnerDbID('campaigns', $event->learner_id);
						if($learnerDbID == null) {
							$learnerDbID = 'NULL';
						}
						$sql = "INSERT INTO events(CAMPAIGN_ID,LEARNER_ID,LEARNER_DB_ID,TYPE_FROM_API,TYPE,DATE_IT_OCCURED,TEMPLATE_ID, TEMPLATE_NAME) VALUES('$event->campaign_id', '$event->learner_id', $learnerDbID, '$event->type', '$eventType', '$timestamp', '$event->template_id', '$templateName')";

						$this->conn->query($sql);
					} 
					// else {
					// 	$sql = "UPDATE events SET TYPE_FROM_API='$event->type', TYPE='$eventType', DATE_IT_OCCURED='$timestamp',TEMPLATE_ID='$event->template_id', TEMPLATE_NAME='$templateName' WHERE ID=$eventDbID";
					// }

					// if($event->campaign_id == 'LK5' && $event->learner_id == 'TD2u' && $event->type == 'phished-learner') {
					// 	return $sql;
					// }
				}
			}
		}
		
		return 'Run phishing finished.';
	}

	public function findEventDbID2($campaignId, $learnerId, $template_id) {
		$sql = "SELECT ID,CAMPAIGN_ID,LEARNER_ID FROM events WHERE TEMPLATE_ID='$template_id' AND CAMPAIGN_ID='$campaignId' AND LEARNER_ID='$learnerId' AND TYPE_FROM_API IN ('phished-learner', 'entered-data', 'opened-attachment', 'enabled-macro', 'replied', 'matched-pattern')";
		$result = $this->conn->query($sql);
		
		while ($row = $result->fetch_row()) {
		    if($row[1] == $campaignId && $row[2] == $learnerId) {
		    	return $row[0];
		    }
		}

		return null;
	}

	public function findEventDbID($campaignId, $learnerId, $templateId, $type) {
		$sql = "SELECT ID,CAMPAIGN_ID,LEARNER_ID FROM events WHERE CAMPAIGN_ID='$campaignId' AND LEARNER_ID='$learnerId' AND TEMPLATE_ID='$templateId' AND TYPE_FROM_API = '$type'";
		$result = $this->conn->query($sql);
		
		while ($row = $result->fetch_row()) {
		    if($row[1] == $campaignId && $row[2] == $learnerId) {
		    	return $row[0];
		    }
		}

		return null;
	}


	public function run($campaignType, $runType = '') {
		$this->campaigns = $this->request("campaigns?limit=100")->data;
		if($runType == RUN_TYPE_SUMMARY) {
			$months = $this->getPreviosMonths();
		} else {
			$months = $this->getCurrentMonth();
		}

		foreach ($this->campaigns as $campaign) {
			
			
			if($this->strpos_arr($campaign->name, $months) && $campaign->type == $campaignType) {
				$data = $this->request("campaigns/{$campaign->id}/runs?limit=100")->data;
				if (!empty($data)) {
					foreach ($data as $value) {	
						$value->compaing_name = $campaign->name;
						$runs[] = $value; 
					}
				}
			}
		}
		
		if(empty($runs)) {
			return 'Not found data.';
		}
		foreach ($runs as $run) {
			if (empty($run)) continue;
			
			$resultLearns = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=1&limit=100");
			
			$learners = $resultLearns->data;
			$pageCount = $resultLearns->meta->pageCount;
			for ($i = 0; $i <= $pageCount; $i++) {

				if($i > 1) {
					$learners = $this->request("campaigns/{$run->campaign_id}/runs/{$run->id}/learners?page=" . $i . "&limit=100")->data;
				}

				if (empty($learners)) continue;
				foreach ($learners as $learner) {
					$user = $this->request("learners/{$learner->id}" );

					$campaign = $this->campaigns[array_search($run->campaign_id, array_column($this->campaigns, 'id'))];

					$this->data[] = array(
						'end' 			=>  $run->end,
						'start'			=> 	$run->start,
						'email' 		=>  $user->email,
						'status' 		=>  $learner->status,
						'course' 		=>  $campaign->name,
						'company' 		=>  $user->learner_profile->custom,
						'user_id' 		=>  $user->id,
						'fullname' 		=>  $user->first_name.' '.$user->last_name,
						'campaign_id' 	=>  $campaign->id,
						'campaign_name' =>  $campaign->name,
						'campaign_type' =>  $campaign->type,
					);


					// Insert company
					$companyName = $user->learner_profile->custom;

					
					$company = $this->getCompany($companyName);
					$learnerProfile = $user->learner_profile;
						
					// Check company exist in database
					if($company == null) {
						$sql = "INSERT INTO companies (NAME, ADDRESS1, ADDRESS2, STATE, CITY, ZIP, COUNTRY, PHONE) VALUES ('$companyName', '$learnerProfile->address1', '$learnerProfile->address2', '$learnerProfile->state', '$learnerProfile->city', '$learnerProfile->zip', '$learnerProfile->country','$learnerProfile->phone')";
						$this->conn->query($sql);

						$companyId = $this->conn->insert_id;
					} else {
						$companyId = $company[0];
					}
					

					$learnerDb = $this->getLearner($learner->id);

					if($learner->status == 'completed') {
						$enrolled = 1;
						$completed = 1;
					} else {
						$enrolled = 1;
						$completed = 0;
					}

					if($this->getCampaignLearner($run->campaign_id, $learner->id) == null) {
						$sql = "INSERT INTO top_learner (COMPAIGN_ID, COMPAIGN_NAME, LEARNER_ID, ENROLLED, COMPLETED, STATUS) VALUES ('$run->campaign_id', '$run->compaing_name', '$learner->id', $enrolled, $completed, '$learner->status')";
					} else {
						$learnerDbID = $this->getLearnerDbID('top_learner', $learner->id);
						$sql = "UPDATE top_learner set COMPLETED=$completed, ENROLLED=$enrolled, STATUS='$learner->status' WHERE COMPAIGN_ID='$run->campaign_id' and ID=$learnerDbID";
					}
					$this->conn->query($sql);

					//
					$sumData = $this->getSumLearner($learner->id);
					
					// Formulor 
					if($sumData['ENROLLED'] == 0)  {
						$progressCompleted = 0;
					} else {
						$progressCompleted = ($sumData['COMPLETED']/$sumData['ENROLLED'])*100;
					}

					
					// Check learner exist in database
					if($learnerDb == null) {
						//insert learner
						$first_name = str_replace("'", "\'", $user->first_name);
						$last_name = str_replace("'", "\'", $user->last_name);

						$fullname =  $first_name.' '. $last_name;
						$startDate = date("Y-m-d H:i:s", strtotime($run->start));
						$endDate = date("Y-m-d H:i:s", strtotime($run->end));
						
						$sql = "INSERT INTO learners (LEARNER_ID, COMPANY_ID, EMAIL, FULLNAME) VALUES ('$learner->id', $companyId, '$user->email', '$fullname')";
						
						$this->conn->query($sql);

						if($learner->status == 'completed') {
							$progressCompleted = 100;
						} else {
							$progressCompleted = 0;
						}	

						$sql = "INSERT INTO campaigns (LEARNER_ID, START, END, FIRST_NAME, LAST_NAME, EMAIL, PROGRESS_COMPLETED, DEPARTMENT) VALUES ('$learner->id', '$startDate', '$endDate', '$first_name', '$last_name', '$user->email', $progressCompleted, '$learnerProfile->department')";
						
						$this->conn->query($sql);
					} else {
						$learnerDbID = $this->getLearnerDbID('campaigns', $learner->id);
						$sql = "UPDATE campaigns set PROGRESS_COMPLETED=$progressCompleted where ID=$learnerDbID";
						$this->conn->query($sql);
					}
				}
			}
		}

		return 'Successfully';
		// foreach ($this->data as $data) {
		// 	if (!array_search($data['company'], array_column($this->companies, 'company'))) {

		// 		$campaigns = array_filter($this->data, function($value) use($data) {
		// 			return $value['company'] == $data['company'];
		// 		}, ARRAY_FILTER_USE_BOTH);

		// 		$this->companies[] = array (
		// 			'company'   => $data['company'],
		// 			'campaigns' => $campaigns
		// 		);
		// 	}
		// }

		// return $this->companies;
	}

	protected function getLearnerDbID($tableName, $learnerId) {
		$sql = "SELECT ID,LEARNER_ID FROM $tableName WHERE LEARNER_ID='$learnerId'";
		
		$result = $this->conn->query($sql);
		
		while ($row = $result->fetch_row()) {
		    if($row[1] == $learnerId) {
		    	return $row[0];
		    }
		}

		return null;
	}

	protected function strpos_arr($haystack, $needle) {
	    if(!is_array($needle)) $needle = array($needle);
	    foreach($needle as $what) {
	        if(($pos = strpos($haystack, $what))!==false) return $pos;
	    }
	    return false;
	}

	protected function getCampaignsByCompany($learnIds, $isSummary) {
		if($isSummary) {
			$sql = "SELECT START,FIRST_NAME,LAST_NAME,DEPARTMENT,PROGRESS_COMPLETED FROM campaigns where ID IN ($learnIds) ORDER BY PROGRESS_COMPLETED DESC,LAST_NAME";
		} else {
			$sql = "SELECT START,FIRST_NAME,LAST_NAME,DEPARTMENT,PROGRESS_COMPLETED FROM campaigns where ID IN ($learnIds) ORDER BY LAST_NAME";
		}

		$result = $this->conn->query($sql);

		while ($row = $result->fetch_row()) {
		    $campaigns[] = array(
		    						'START' 				=> date("m/d/Y", strtotime($row[0])), 
		    						'FULL_NAME' 			=> $row[1] . ' ' . $row[2], 
		    						'FIRST_NAME' 			=> $row[1],
		    						'LAST_NAME' 			=> $row[2],
		    						'DEPARTMENT'			=> $row[3],
		    						'PROGRESS_COMPLETED' 	=> $row[4]
		    					);
		}

		return $campaigns;
	}

	protected function getCompanyNameById($companies, $companyId) {
		foreach ($companies as $key => $company) {
			if($company['ID'] == $companyId){
				return $company['NAME'];
			}
		}
	}

	protected function getCompanyByLearner($learnerId) {
		$sql = "SELECT COMPANY_ID,LEARNER_ID FROM learners WHERE LEARNER_ID='$learnerId'";

		$result = $this->conn->query($sql);

		while ($row = $result->fetch_row()) {
		    if($row[1] == $learnerId) {
		    	return $row[0];
		    }
		}

		return null;
	}

	protected function getCompanies() {
		$sql = "SELECT * FROM companies";
		
		$result = $this->conn->query($sql);

		while ($row = $result->fetch_row()) {
		    $companies[] = array('ID' => $row[0], 'NAME' => $row[1]);
		}

		return $companies;
	}

	protected function getCompany($campanyName) {
		$sql = "SELECT * FROM companies WHERE NAME='$campanyName'";
		
		return $this->getSingleRow($sql);
	}

	protected function getLearner($learnerId) {
		$sql = "SELECT * FROM learners WHERE LEARNER_ID='$learnerId'";
		
		$result = $this->conn->query($sql);

		while ($row = $result->fetch_row()) {
		    if($row[1] == $learnerId) {
		    	return $row;
		    }
		}

		return null;
	}

	protected function getCampaignLearner($campaignId, $learnerId) {
		$sql = "SELECT COMPAIGN_ID,LEARNER_ID FROM top_learner WHERE COMPAIGN_ID='$campaignId' AND LEARNER_ID='$learnerId' ";
		
		$result = $this->conn->query($sql);
		while ($row = $result->fetch_row()) {
		    if($row[0] == $campaignId && $row[1] == $learnerId) {
		    	return $row;
		    }
		}

		return null;
	}

	protected function getSumLearner($learnerId) {
		$sql = "SELECT ENROLLED,COMPLETED,LEARNER_ID FROM top_learner WHERE LEARNER_ID='$learnerId' ";
		$enrolled = 0;
		$completed = 0;
		$result = $this->conn->query($sql);
		while ($row = $result->fetch_row()) {
		    if($row[2] == $learnerId) {
		    	
		    	if($row[0] == 1) {
		    		$enrolled ++;
		    	}
		    	if($row[1] == 1) {
		    		$completed ++;
		    	}
		    }
		}
		
		return array('ENROLLED' => $enrolled, 'COMPLETED' => $completed);
	}

	protected function getSingleRow($sql) {
		$result = $this->conn->query($sql);

		return $result->fetch_row();
	}

	protected function sendMail($subject, $data, $toEmail, $nameOfContact, $templateType) {
		try {
			global $mail;
			$mail->ClearAllRecipients( ); // clear all
			$mail->setFrom('donotreply@visible-iq.com');
			$toEmailList = explode(",",$toEmail);
			
			foreach ($toEmailList as $key => $value) {
				$mail->addAddress($value);
			}
			$mail->addCC('damians@fluidnets.com');
			$mail->addCC('fahds@fluidnets.com');
			$mail->addCC('mattd@fluidnets.com');
			$mail->addCC('tawnees@fluidnets.com');
			$mail->Subject = $subject;
			$mail->isHTML(TRUE);
			$mail->Body = $this->mail_template($data, $nameOfContact, $templateType);

			$mail->send();


		} catch (Exception $e) {
		    echo "$mail->ErrorInfo";
		}
	}

	protected function getPreviosMonths() {
		// $currentMonth = 4;

		$currentMonth = date("m");
		if($currentMonth == 1) {
			$data[] = (date("y") - 1) . '12';
		}
		for ($i=1; $i < $currentMonth; $i++) { 
			// if($i <= 7) {
			// 	continue;
			// }
 			$data[] = date("y") . ($i < 10 ? '0' . $i : $i);
 		}

 		// $data = null;
		// $data[] = '2103';

 		return $data;
	}

	protected function getCurrentMonth() {
		if(date("m") == 1) {
			$data[] = (date("y") - 1) . date("m", strtotime("-1 months"));
		} else {
			$data[] = date("y") . date("m", strtotime("-1 months"));
		}

		return $data;
	}

	protected function mail_template($data, $nameOfContact, $templateType) {
		if($templateType == MAIL_SUMMARY_TEMPLATE) {
			$content = file_get_contents(dirname(__FILE__).'/template_mail_summary.html');
		} else if($templateType == MAIL_PHISHING_TEMPLATE) {
			$content = file_get_contents(dirname(__FILE__).'/template_mail_phishing.html');
		} 
		else {
			$content = file_get_contents(dirname(__FILE__).'/template_mail.html');
		} 

		$content = str_replace("<%ReportTable%>","$data", $content);
		return str_replace("<%NameOfContact%>","$nameOfContact", $content); 
	}

	protected function request($url, $params=[]) {
       	$ch = curl_init(API_HOST . $url);

       	$authorization = "Authorization: Bearer " . API_BEARER_TOKEN;
       	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization ));

       	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

       $response = curl_exec($ch);
       curl_close($ch);
       return json_decode($response);
	}
}

?>