<?php

require "../bootstrap.php";

try {
    $campaigns = $Processor->fetch_campaigns_by_type("awareness");
    $campaigns = $Processor->filter_campaign_by_current_month($campaigns);

    $runs = [];

    // GET ALL RUNS FOR EACH CAMPAIGN
    foreach ($campaigns as $campaign) {
        $currentPage = 1;

        $response_data = $Processor->request("campaigns/" . $campaign['campaign_id'] . "/runs?limit=100&page=$currentPage");

        while (isset($response_data->data) && !is_null($response_data->data)) {
            $campaign_runs = $response_data->data;
            $runs = array_merge($runs, $campaign_runs);
            $currentPage++;
            $response_data = $Processor->request("campaigns/" . $campaign['campaign_id'] . "/runs?limit=100&page=$currentPage");
        }
    }

    $message = $Processor->insert_campaign_runs($runs);

    return return_json(['message' => $message]);
} catch (Exception $e) {
    return return_json(['error' => $e->getMessage() . ' at line ' . $e->getLine()]);
}