<?php

require "../bootstrap.php";

try {
    // get runs
    $runs = $Processor->get_runs();
    $runs = $Processor->filter_run_by_active($runs);
    $num = 0;

    foreach ($runs as $run) {
        $currentPage = 1;

        $run_statistics_response = $Processor->request("campaigns/" . $run['campaign_id'] . "/runs/" . $run['run_id'] . "/learners?limit=100&page=$currentPage");
        $finalData = [];

        $data = null;

        while (isset($run_statistics_response->data) && !is_null($run_statistics_response->data)) {
            $data = $run_statistics_response->data;

            $finalData = array_merge($finalData, $data);

            $num += $Processor->insert_run_statistics($finalData, $run['run_id'], $run['campaign_id']);

            $currentPage++;
            $run_statistics_response = $Processor->request("campaigns/" . $run['campaign_id'] . "/runs/" . $run['run_id'] . "/learners?limit=100&page=$currentPage");
        }
    }

    return return_json(['message' => "$num stats inserted."]);
} catch (Exception $e) {
    return return_json(["error" => $e->getMessage() . ' at line ' . $e->getLine()]);
}