<?php 

require '../bootstrap.php';

//is_ajax();

try {
    $companies = $Processor->get_companies();

    $campaigns = $Processor->get_campaigns();
    $campaigns = $Processor->filter_campaigns_by_prev_month($campaigns);
    $campaignIds =$Processor->campaigns_to_ids($campaigns);

    // return return_json( $campaigns );

    // $now = new DateTime("now");

    // $now->modify("first day of -1 month");
    // $firstday = $now->format("Y-m-d") . " 00:00:00";

    // // $now->modify("first day of 1 month");
    // $now->modify("last day of this month");
    // $lastday = $now->format("Y-m-d"). " 23:59:59";

    $types = ['phished-learner', 'entered-data', 'opened-attachment', 'enabled-macro', 'replied', 'matched-pattern'];

    $events = $Processor->get_timeline_events_by_campaign($campaignIds);

    $filteredEvents = [];

    $result = [];

    foreach ($events as $event) {
        // return return_json( $event['type_from_api'] );
        if (in_array(strtolower($event['type_from_api']), $types)) { 
            // $filteredEvents[] = $event; 
            $eventId = $event['id'];
            $companyName = $event['company_name'];

            if ($companyName == null) continue;

            if ($result[$companyName] == null) {
                $result[$companyName] = array(
                    "eventIds" =>  "$eventId",
                );
            } else {
                $eventIds = $result[$companyName]['eventIds'] . ",$eventId";
                $result[$companyName] = array(
                    "eventIds" => $eventIds
                );
            }
        }
    }

    // return return_json(['filtered' => count($filteredEvents), 'events' => count($events)]);

    // return return_json(["events" => count($events), "result" => $result]);

    if($result == null) {
        return 'Data not found';
    }

    // SEND MAILS
    foreach ($result as $key => $item) {
        $subject = "Security Awareness - ". $key . " - Phished Users";
		$rowData = '';
        $events = $Processor->get_events($item['eventIds']);
        
        $emailAndNameOfContact = $Processor->getEmailAndNameOfContact($key);

        if (empty($events)) {
            continue;
        }

        foreach ($events as $event) {			
            $rowData .= "<tr>";
            $rowData .= "<td>" . $event['campaign_name'] . "</td>";
            $rowData .= "<td>" . $event['first_name'] . ' ' . $event['last_name'] . "</td>";
            $rowData .= "<td>" . $event['date_it_occured'] . "</td>";
            $rowData .= "<td>" . $event['type'] . "</td>";
            $rowData .= "<td>" . $event['template_name'] . "</td>";
            $rowData .= "</tr>";
        }

        $Processor->send_phishing_mail($subject, $rowData, $emailAndNameOfContact['toEmail'], $emailAndNameOfContact['nameOfContact']);
    }

    return 'Send Mail Phishing Finish...';

} catch(Exception $e) {
    return return_json(['error' => $e->getMessage().' at line '.$e->getLine()]);
}

?>